#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <regex.h>

#include "udm_config.h"
#include "udm_utils.h"
#include "udm_common.h"
#include "udm_mimetype.h"
#include "udm_xmalloc.h"


/********* AddType stuff *********************/

typedef struct mime_struct {
	int	flags;
	regex_t	regex;
	char *	mime_type;
	char *	regstr;
} UDM_MIME;

#define ERRSTRSIZE 100
#define NS 10


int UdmMimeTypeAdd(UDM_ENV *Conf,const char *mime_type,const char *regstr, int flags){
	char		regerrstr[ERRSTRSIZE];
	int		err;
	UDM_MIMELIST	*List=&Conf->MimeTypes;
	UDM_MIME	*Mime;

	if(List->nmimes>=List->mmimes){
		List->mmimes+=16;
		List->Mime=UdmXrealloc(List->Mime,List->mmimes*sizeof(UDM_MIME));
	}
	Mime=(UDM_MIME*)List->Mime;
	Mime+=List->nmimes;
	Mime->mime_type=strdup(mime_type);
	Mime->regstr=strdup(regstr);
	Mime->flags=flags;

	if(Mime->flags&UDM_MIME_REGEX){
		if(Mime->flags&UDM_MIME_CS){
			err=regcomp(&(Mime->regex),regstr,REG_EXTENDED);
		}else{
			err=regcomp(&(Mime->regex),regstr,REG_EXTENDED|REG_ICASE);
		}
		if(err){
			regerror(err,&(Mime->regex),regerrstr,ERRSTRSIZE);
			Conf->errcode=1;
			sprintf(Conf->errstr,"Wrong regex in config file: %s: %s", regstr,regerrstr);
			free(Mime->mime_type);
			free(Mime->regstr);
			return(1);
		}
	}
	List->nmimes++;
	return(0);
}

void UdmMimeTypeListFree(UDM_MIMELIST *List){
	size_t i;
	UDM_MIME * Mime=(UDM_MIME*)List->Mime;
	
	for(i=0;i<List->nmimes;i++){
		free(Mime[i].regstr);
		free(Mime[i].mime_type);
		if(Mime[i].flags&UDM_MIME_REGEX)
			regfree(&(Mime[i].regex));
	}
	List->nmimes=List->mmimes=0;
	UDM_FREE(List->Mime);
}

const char * UdmContentType(UDM_MIMELIST *List,const char *url){
	size_t i;
	regmatch_t subs[NS];
	int err;
	UDM_MIME * Mime=(UDM_MIME*)List->Mime;

	for(i=0;i<List->nmimes;i++){
		if(Mime[i].flags&UDM_MIME_REGEX){
			err=regexec(&(Mime[i].regex),url,NS,subs,0);
		}else{
			if(Mime[i].flags&UDM_MIME_CS){
				err=UdmStrMatch(url,Mime[i].regstr);
			}else{
				err=UdmStrCaseMatch(url,Mime[i].regstr);
			}
		}
		if(!err)return(Mime[i].mime_type);
	}
	return(NULL);
}
